/********************************************
; File: AppleTalk.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/

#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __APPLETALK__
#define __APPLETALK__


/* Command Numbers */
#define atGetInfoCommand 0x0002
#define atGetGlobalCommand 0x0003
#define atInstallTimerCommand 0x0004
#define atRemoveTimerCommand 0x0005
#define atBootCommand 0x0006
#define atCancelTimerCommand 0x0045

/* Link Access Protocol Codes */
#define lapWriteCommand 0x0007
#define lapReadBufferCommand 0x0008
#define lapAttachProtCommand 0x0009
#define lapRemoveProtCommand 0x000A

/* Datagram Delivery Protocol Codes */
#define ddpOpenSocketCommand 0x000B
#define ddpCloseSocketCommand 0x000C
#define ddpSendDatagramCommand 0x000D

/* Name Binding Protocol Codes */
#define nbpRegisterNameCommand 0x000E
#define nbpRemoveNameCommand 0x000F
#define nbpLookupNameCommand 0x0010
#define nbpConfirmNameCommand 0x0011
#define nbpKillCommand 0x0046

/* AppleTalk Transaction Protocol Codes */
#define atpSendReqCommand 0x0012
#define atpCancelReqCommand 0x0013
#define atpOpenSocketCommand 0x0014
#define atpCloseSocketCommand 0x0015
#define atpGetReqCommand 0x0016
#define atpSendRespCommand 0x0017
#define atpRelCBCommand 0x0019

/* Zone Information Protocol Codes */
#define zipGetMyZoneCommand 0x001A
#define zipGetZoneListCommand 0x001B

/* AppleTalk Session Protocol Codes */
#define aspGetParmsCommand 0x001C
#define aspGetStatusCommand 0x001D
#define aspOpenSessionCommand 0x001E
#define aspCloseSessionCommand 0x001F
#define aspCommandCommand 0x0020
#define aspWriteCommand 0x0021

/* Printer Access Protocol Codes */
#define papStatusCommand 0x0022
#define papOpenCommand 0x0023
#define papCloseCommand 0x0024
#define papReadCommand 0x0025
#define papWriteCommand 0x0026
#define papUnloadCommand 0x0027

/* Remote Print Manager Codes */
#define rpmSetPrinterCommand 0x0028
#define rpmCloseSessionCommand 0x0047
#define rpmFlushSessionCommand 0x0048

/* ProDOS Filing Interface Codes */
#define pfiUserPrefixCommand 0x002A
#define pfiLoginCommand 0x002B
#define pfiLoginContCommand 0x002C
#define pfiLogOutCommand 0x002D
#define pfiMountVolCommand 0x002E
#define pfiListSessionsCommand 0x002F
#define pfiTimeZoneCommand 0x0030
#define pfiGetSrcPathCommand 0x0031
#define pfiAccessCommand 0x0032
#define pfiNamingCommand 0x0033
#define pfiConvertTimeCommand 0x0034
#define pfiSetBufferCommand 0x0036
#define pfiHooksCommand 0x0037
#define pfiLogin2Command 0x0038
#define pfiListSessions2Command 0x0039
#define pfiGetSVersionCommand 0x003A

/* Error Codes */
#define appleTalkNetError 0x8888 /* AppleTalk Network Error */
#define atInvalidCmdErr 0x0101  /* Invalid command */
#define atMemoryErr 0x0102  /* Heap/memory management error */
#define atTimerNotInstalledErr 0x0103  /* No timer installed error */
#define atSyncErr 0x0104  /* Syncronous only call */
#define atTooManyTimes 0x0105  /* Too many times */
#define atTimerCancelled 0x0106

/* LAP Error Codes */
#define lapNoPacketErr 0x0201  /* No packet in buffer */
#define lapEOBErr 0x0202  /* End of buffer */
#define lapLenErr 0x0203  /* LAP data too large */
#define lapFailedErr 0x0204  /* Retry count exhausted */
#define lapTypeErr 0x0205  /* Illegal LAP type */
#define lapDuplicateErr 0x0206  /* Duplicate LAP type */
#define lapProtocolErr 0x0207  /* Too many protocols */
#define lapTypeFoundErr 0x0208  /* Type not found */
#define lapDataLostErr 0x0209  /* Data lost in Purge */

/* DDP Error Codes */
#define ddpSktNumErr 0x0301  /* Too many sockets open */
#define ddpSktErr 0x0302  /* Socket not open */
#define ddpSktOpenErr 0x0303  /* Socket already open */
#define ddpSktTypeErr 0x0304  /* Invalid Socket Type */
#define ddpLenErr 0x0305  /* DDP length error */
#define ddpBridgeErr 0x0306  /* No bridge available */

/* NBP Error Codes */
#define nbpNameNumberErr 0x0401  /* Too many names */
#define nbpNameExistErr 0x0402  /* Name already exists */
#define nbpNameFoundErr 0x0403  /* Name not found */
#define nbpBufferErr 0x0404  /* User buffer full */
#define nbpWildcardErr 0x0405  /* Wildcard not allowed */
#define nbpNameErr 0x0406  /* Invalid name format */
#define nbpAddressErr 0x0407  /* Incorrect address */
#define nbpProcessErr 0x0408  /* Too many NBP processes */
#define nbpAbortErr 0x0409  /* NBP Aborted */
#define nbpParmBlkNotFndErr 0x040A  /* NBP Param Block not found */

/* ATP Error Codes */
#define atpDataLenErr 0x0501  /* ATP data too large */
#define atpSocketErr 0x0502  /* Invalid ATP socket */
#define atpControlBlkErr 0x0503  /* ATP control block not found */
#define atpProcessErr 0x0504  /* Too many active ATP calls */
#define atpReleaseErr 0x0505  /* No release received */
#define atpNoRespActive 0x0506  /* No response active */
#define atpRespErr 0x0507  /* No send response active */
#define atpReqErr 0x0508  /* ATP send request aborted */
#define atpSktClosedErr 0x0509  /* socket closed error */
#define atpTooManySkts 0x050A  /* Too many ATP sockets */
#define atpTooManyResp 0x050B  /* Too many responses expected */
#define atpDDPSktErr 0x050C  /* Unable to open DDP socket */
#define atpSndRespRelErr 0x050D  /* ATP Send Response was released */

/* ZIP Error Codes */
#define zipNetworkErr 0x0601  /* Network error */
#define zipOverflow 0x0602  /* ZIP overflow */
#define zipNotFound 0x0603  /* ZIP not found */

/* ASP Error Codes */
#define aspNetworkErr 0x0701  /* Network error */
#define aspSessNumErr 0x0702  /* Too many sessions */
#define aspRefErr 0x0703  /* Invalid reference number */
#define aspSizeErr 0x0704  /* Size error */
#define aspBufErr 0x0705  /* Buffer error */
#define aspNoRespErr 0x0706  /* No response from server */
#define aspBadVersion 0x0707  /* Bad version number */
#define aspTooManySessions 0x0708  /* Too many sessions */
#define aspServBusyErr 0x0709  /* Server busy */
#define aspSessionClosed 0x070A  /* Session closed */

/* PAP Error Codes */
#define papSessNumErr 0x0801  /* Too many sessions */
#define papRefErr 0x0802  /* Invalid Reference */
#define papQuantumErr 0x0803  /* Quantum Error */
#define papCommandErr 0x0804  /* Too many commands */
#define papNameErr 0x0805  /* Name not found */
#define papSessionErr 0x0806  /* Session closed */
#define papNetworkErr 0x0807  /* Network error */
#define papServRespErr 0x0808  /* Server not responding */
#define papServBusyErr 0x0809  /* Server busy */
#define papBuffSizeErr 0x080A  /* Buffer size error */
#define papInUseErr 0x080B  /* PAP in use */

/* RPM Error Codes */
#define rpmInvalidFlagErr 0x0901
#define rpmInvalidTimeErr 0x0902

/* PFI Error Codes */
#define pfiTooManySessErr 0x0A01  /* Too many sessions */
#define pfiUnableOpenSessErr 0x0A02  /* Unable to open session */
#define pfiNoRespFrmSrvrErr 0x0A03  /* No response from server */
#define pfiLoginContErr 0x0A04  /* Login continue */
#define pfiInvalidNameErr 0x0A05  /* Invalid name */
#define pfiInvalidSessNumErr 0x0A06  /* Invalid Sess reference # or unknown volume */
#define pfiUnableOpenVolErr 0x0A07  /* Unable to open volume */
#define pfiTooManyVolsOpenErr 0x0A08  /* Too many mounted volumes */
#define pfiVolNotMountedErr 0x0A09  /* Volume Not Mounted */
#define pfiUnableSetCreatorErr 0x0A0A
#define pfiBufferToSmallErr 0x0A0B  /* Buffer to small */
#define pfiTimeFlagErr 0x0A0C  /* Time flag error */
#define pfiUnableTSetGroupErr 0x0A0D  /* Unable to set group */
#define pfiDirNotFoundErr 0x0A0E  /* Directory not found */
#define pfiAccessDeniedErr 0x0A0F  /* Access denied */
#define pfiMiscellaneousErr 0x0A10  /* Miscellaneous error */
#define pfiVolAlreadyMntedErr 0x0A11  /* Volume already mounted */
#define pfiUnableGetCreatorErr 0x0A12  /* Unable to get creator/group */
#define pfiAlrdyLggedOnSrvrErr 0x0A13  /* Already logged onto server */
#define pfiTimeError 0x0A14  /* Time error */
#define pfiUserNotAuthorizedErr 0x0A15  /* User not authorized */
#define pfiParamterErr 0x0A16  /* Parameter error */
#define pfiSrvrGoingDownErr 0x0A17  /* Server going down */
#define pfiBadUAMErr 0x0A18  /* Bad UAM */
#define pfiBadVersionNumErr 0x0A19  /* Bad version number */

/* ATInit offsets */
#define atInitUserName 0x0085  /* 133 */
#define atInitPrinterFlags 0x0064  /* 100 */
#define atInitPrinterTuple 0x0063  /* 99 */
#define atInitPrefix 0x00C6  /* 198 */
#define atInitPrefixDirID 0x00CA  /* 202 */
#define atInitPrefixVolID 0x00CC  /* 204 */
#define atInitPath 0x010D  /* 269 */
#define atInitPathDirID 0x0111  /* 273 */
#define atInitPathVolID 0x0113  /* 275 */

/* ATGetInfoRec.hardwareID flags */
#define hidAppleIIGS 0x0000

/* ATInstallTimerRec.ticksToComplete values  */
#define atMaxTicks 0xFFFF
#define atMaxTicksIIe 0x1FFF

/* LAPReadBufferRec.purge values */
#define lapPurgeOff 0x0000
#define lapPurgeOn 0x0001

/* DDPSendDatagramRec.checksum values */
#define ddpChecksumOff 0x00
#define ddpChecksumOn 0x01

/* NBPRegsterNameRec.checkFlag values */
#define nbpCheckNameOn 0x00
#define nbpCheckNameOff 0x01

/*
    ATPSendReqRec.atpFlags and 
    ATPGetReqRec.atpFlags values
*/

#define atpExactlyOnceMask 0x20

/* ATPSendReqRec.result value (low byte) */
#define atpExecuting 0xFF

/* ATPOpenSocketRec.socketID values */
#define atpDynamicSocket 0x00

/* ASPAttenHeaderRec.attenType values */
#define aspAttenNormal 0x00
#define aspAttenTimeout 0x40
#define aspAttenClosed 0x80

/* RPMSetPrinterRec.timeOut values */
#define rpmTimeOutOff 0x0000

/* RPMSetPrinterRec.rpmFlags masks */
#define rpmNetworkMask 0x80
#define rpmPostscriptMask 0x20
#define rpmReturnNameMask 0x01

/* PFIMountVolRec.mountFlag masks */
#define pfiMountMask 0x80
#define pfiPasswordMask 0x40
#define pfiUserVolumeMask 0x01

/* PFITimeZoneRec.timeFlag masks */
#define pfiEastWestMask 0x80
#define pfiHoursAwayMask 0x7F

/* PFIAccessRec.directionalFlag masks */
#define pfiSetAccessMask 0x80
#define pfiCreatorMask 0x40
#define pfiGroupMask 0x20

/* PFINamingRec masks */
#define pfiDNCMask 0x80  /* PFI Directional Naming Convention Mask */
#define pfiDDTMask 0x40  /* PFI Directional Device Table Mask */
#define pfiNNCMask 0x80  /* PFI Naming Naming Convention Mask */
#define pfiNDTMask 0x40  /* PFI Naming Device Table Mask */

/* LAPAttachProtRec.protType values */
#define lapProtTypeMin 0x01
#define lapProtTypeMax 0x7F
#define lapProtTypeAll 0xFF

/* Socket Range values */
#define atpSocketDynamicMin 0x80
#define atpSocketDynamicMax 0xFE
#define atpSocketStaticMin 0x01
#define atpSocketStaticMax 0x7F

/* Buffer length constants */
#define zipGetMyZoneBufLenMin 0x21  /* 33 */
#define papOpenStatusBufLenMin 0x0104  /* 260 */
#define pfiUserNameLenMax 0x0040  /* 64 */

/* Other misc constants */
#define workstationGS 0x0000
#define endOfBDS 0xFFFF
#define ddpInvalidClient 0x00
#define atpActualLengthMask 0x7FFF
#define atpActualLengthOvflw 0x8000
#define atpUnusedAddRtnPtr 0x00000000L
#define atpUnusedAddBitMap 0x00
#define pfiAFPVersion11 0x0101
#define pfiAFPVersion20 0x0200
#define pfiAFPTimeFormat 0x0000
#define pfiProDOSTimeFormat 0x0001
#define pfiHooksSetHooks 0x40
#define pfiHooksP8Active 0x80
#define pfiSetWriteBuffer 0x80
#define papReadNotEOF 0x00

/* TYPES */

struct EntName {
   Byte buffer[99]; /*   */
} ;
typedef struct EntName EntName;

/* embedded EntName fields */

typedef Str32 objStr;
typedef Str32 typeStr;
typedef Str32 zoneStr;

typedef char GetMyZoneBuf[zipGetMyZoneBufLenMin];
typedef char PAPOpenStatusBuf[papOpenStatusBufLenMin];
typedef char PFIUserName[pfiUserNameLenMax];

struct ATInitTailRec {
   Word pathVolID; /*   */
   LongWord pathDirID; /*   */
   char path[65]; /*   */
   Word prefixVolID; /*   */
   LongWord prefixDirID; /*   */
   char prefix[65]; /*   */
   char userName[33]; /*   */
   Byte printerFlags; /*   */
   Byte printerTuple[99]; /*   */
} ;
typedef struct ATInitTailRec ATInitTailRec, *ATInitTailRecPtr, **ATInitTailRecHndl;

struct ATGetInfoRec {
   Byte async;
   Byte command;
   Word result;
   LongWord completionRtn;
   Word thisNet;
   Byte aBridge;
   Byte hardwareID;
   Word romVersion;
   Byte nodeNumber;
} ;
typedef struct ATGetInfoRec ATGetInfoRec, *ATGetInfoRecPtr, **ATGetInfoRecHndl;

struct ATGetGlobalRec {
   Byte async;
   Byte command;
   Word result;
   Ptr bufferPtr;
} ;
typedef struct ATGetGlobalRec ATGetGlobalRec, *ATGetGlobalRecPtr, **ATGetGlobalRecHndl;

struct ATGetGlobalBuffer {
   Byte destinationNode;
   Byte lapSourceNode;
   Byte lapType;
   Byte hopCountDL;
   Byte datagramLength;
   Word ddpChecksum;
   Word destNetwork;
   Word sourceNetwork;
   Byte destinationNode;
   Byte sourceNode;
   Byte destinationSocket;
   Byte sourceSocket;
   Byte ddpType;
   Word packetLength;
} ;
typedef struct ATGetGlobalBuffer ATGetGlobalBuffer, *ATGetGlobalBufferPtr, **ATGetGlobalBufferHndl;

struct ATInstallTimerRec {
   Byte async;
   Byte command;
   Word result;
   LongWord completionRtn;
   Word runningTickCount;
   Word ticksToComplete;
   Pointer reserved;
} ;
typedef struct ATInstallTimerRec ATInstallTimerRec, *ATInstallTimerRecPtr, **ATInstallTimerRecHndl;

struct ATRemoveTimerRec {
   Byte async;
   Byte command;
   Word result;
   Byte reserved[12];
} ;
typedef struct ATRemoveTimerRec ATRemoveTimerRec, *ATRemoveTimerRecPtr, **ATRemoveTimerRecHndl;

struct ATBootRec {
   Byte async;
   Byte command;
   Word result;
} ;
typedef struct ATBootRec ATBootRec, *ATBootRecPtr, **ATBootRecHndl;

struct ATCancelTimerRec {
   Byte async;
   Byte command;
   Word result;
   Byte reserved[12];
} ;
typedef struct ATCancelTimerRec ATCancelTimerRec, *ATCancelTimerRecPtr, **ATCancelTimerRecHndl;

struct ASPAttentionHeaderRec {
   Byte sessionRefNum; /*   */
   Byte attenType; /*   */
   Word atten; /*   */
} ;
typedef struct ASPAttentionHeaderRec ASPAttentionHeaderRec, *ASPAttentionHeaderRecPtr, **ASPAttentionHeaderRecHndl;

struct ASPGetParmsRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   Word maxCmdSize;
   Word maxDataSize;
} ;
typedef struct ASPGetParmsRec ASPGetParmsRec, *ASPGetParmsRecPtr, **ASPGetParmsRecHndl;

struct ASPGetStatusRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Word slsNet; /* SLS Network Number */
   Byte slsNode; /* SLS Node Number */
   Byte slsSocket; /* SLS Socket Number */
   Word bufferLength; /* Buffer Length */
   LongWord bufferAddr; /* Buffer Address */
   Word dataLength; /* Length of Status Data */
} ;
typedef struct ASPGetStatusRec ASPGetStatusRec, *ASPGetStatusRecPtr, **ASPGetStatusRecHndl;

struct ASPOpenSessionRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Word slsNet; /* SLS Network Number */
   Byte slsNode; /* SLS Node Number */
   Byte slsSocket; /* SLS Socket Number */
   LongWord attnRtnAddr; /* Attention Routine Addr */
   Byte refNum; /* Session Reference Number */
} ;
typedef struct ASPOpenSessionRec ASPOpenSessionRec, *ASPOpenSessionRecPtr, **ASPOpenSessionRecHndl;

struct ASPCloseSessionRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Byte refNum; /* Session Reference Number */
} ;
typedef struct ASPCloseSessionRec ASPCloseSessionRec, *ASPCloseSessionRecPtr, **ASPCloseSessionRecHndl;

struct ASPCommandRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Byte refNum; /* Session Reference Number */
   Word cmdBlkLength; /* Command Block Length */
   LongWord cmdBlkAddr; /* Command Block Address */
   Word replyBufferLen; /* Reply Buffer Length */
   LongWord replyBufferAddr; /* Reply Buffer Address */
   LongWord cmdResult; /* Command Result */
   Word replyLength; /* Reply Length */
} ;
typedef struct ASPCommandRec ASPCommandRec, *ASPCommandRecPtr, **ASPCommandRecHndl;

struct ASPWriteRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Byte refNum; /* Session Reference Number */
   Word cmdBlkLength; /* Command Block Length */
   LongWord cmdBlkAddr; /* Command Block Address */
   Word writeDataLength; /* Write Data Length */
   LongWord writeDataAddr; /* Write Data Address */
   Word replyBufferLen; /* Reply Buffer Length */
   LongWord replyBufferAddr; /* Reply Buffer Address */
   LongWord cmdResult; /* Command Result */
   Word writtenLength; /* Written Length */
   Word replyLength; /* Reply Length */
} ;
typedef struct ASPWriteRec ASPWriteRec, *ASPWriteRecPtr, **ASPWriteRecHndl;

struct Server {
   Pointer serverName; /* Pointer to a Server Entity */
   Word net; /* Net of the server */
   Byte node; /* Node of the server */
   Byte socket; /* Socket number of the server */
} ;
typedef struct Server Server, *ServerPtr, **ServerHndl;

struct ATPSendReqRec {
   Byte async; /* asyncronous flag */
   Byte command; /* ATP command to execute */
   Word result; /* error result from the ATP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Byte socketID; /* dynamic socket number */
   Word destNetID; /* destination network # */
   Byte destNodeID; /* destination node # */
   Byte destSocketID; /* destination socket # */
   Word transactionID; /* transaction ID # */
   Word reqBufferLength; /* request buffer length */
   LongWord reqBufferPtr; /* pointer to the request buffer */
   LongWord userBytes; /* user BYTEs */
   Byte numRespBuffers; /* number of response buffers */
   LongWord respBufferPtr; /* pointer to the response buffer */
   Byte atpFlags; /* flags for ATP transaction */
   Byte rInterval; /* timeout before retrying */
   Byte rCount; /* number of retries to attempt */
   Byte bitMap; /* bitmap indicating for packet reception */
   Byte responseRcv; /* number of responses received */
   Byte reserved; /* reserved for future use */
} ;
typedef struct ATPSendReqRec ATPSendReqRec, *ATPSendReqRecPtr, **ATPSendReqRecHndl;

struct ATPCancelReqRec {
   Byte async; /* asyncronous flag */
   Byte command; /* ATP command to execute */
   Word result; /* error result from ATP operation */
   Word transactionID; /* transaction ID # */
} ;
typedef struct ATPCancelReqRec ATPCancelReqRec, *ATPCancelReqRecPtr, **ATPCancelReqRecHndl;

struct ATPOpenSocketRec {
   Byte async; /* asyncronous flag */
   Byte command; /* ATP command to execute */
   Word result; /* error result from the ATP operation */
   Byte socketID; /* socket number to open */
} ;
typedef struct ATPOpenSocketRec ATPOpenSocketRec, *ATPOpenSocketRecPtr, **ATPOpenSocketRecHndl;

struct ATPCloseSocketRec {
   Byte async; /* asyncronous flag */
   Byte command; /* ATP command to execute */
   Word result; /* error result from ATP operation */
   Byte socketID; /* socket number for closing */
} ;
typedef struct ATPCloseSocketRec ATPCloseSocketRec, *ATPCloseSocketRecPtr, **ATPCloseSocketRecHndl;

struct ATPGetReqRec {
   Byte async; /* asyncronous flag */
   Byte command; /* ATP command to execute */
   Word result; /* error result from ATP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Byte respSocketID; /* response socket # */
   Word networkID; /* source network # */
   Byte nodeID; /* source node # */
   Byte socketID; /* source socket # */
   Word transactionID; /* ATP transaction ID */
   Word reqBufferLength; /* request buffer length */
   LongWord reqBufferPtr; /* pointer to request buffer */
   LongWord userBytes; /* user BYTEs */
   Word requestLength; /* actual request length */
   Byte atpFlags; /* ATP operation flags */
   Byte bitMap; /* bitmap for packet reception */
   LongWord reserved; /* reserved for future use */
} ;
typedef struct ATPGetReqRec ATPGetReqRec, *ATPGetReqRecPtr, **ATPGetReqRecHndl;

struct ATPSendRespRec {
   Byte async; /* asyncronous flag */
   Byte command; /* ATP command to execute */
   Word result; /* result to the ATP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Byte socketID; /* response socket # */
   Word destNetID; /* destination network # */
   Byte destNodeID; /* destination node # */
   Byte destSocketID; /* destination socket # */
   Word transactionID; /* transaction ID # */
   Byte numRespBuffers; /* number of response buffers */
   Byte totalPackets; /* total ATP packets */
   LongWord respBDSPtr; /* pointer to the BDS buffer */
   Byte atpFlags; /* ATP operation flags */
   Byte bitmap; /* bitmap for packet reception */
   LongWord reserved; /* must be set to NIL for future compatibility */
   Byte reserved2; /* must be set to 0 for future compatibility */
} ;
typedef struct ATPSendRespRec ATPSendRespRec, *ATPSendRespRecPtr, **ATPSendRespRecHndl;

struct ATPRelCBRec {
   Byte async; /* asyncronous flag */
   Byte command; /* ATP command to execute */
   Word result; /* error result to the ATP operation */
   Byte socketID; /* response socket # */
   Word destNetID; /* destination network # */
   Byte destNodeID; /* destination node # */
   Byte destSocketID; /* destination socket # */
   Word transactionID; /* ATP transaction ID */
} ;
typedef struct ATPRelCBRec ATPRelCBRec, *ATPRelCBRecPtr, **ATPRelCBRecHndl;

struct RespBDSBuffer {
   Word bufferLength;
   LongWord bufferPtr;
   LongWord userBytes;
   Word actualLength;
} ;
typedef struct RespBDSBuffer RespBDSBuffer, *RespBDSBufferPtr, **RespBDSBufferHndl;

struct DDPOpenSocketRec {
   Byte async; /* asyncronous flag */
   Byte command; /* DDP command to execute */
   Word result; /* error result from DDP operation */
   Byte socketNumber; /* socket number opened */
   LongWord clientAddr; /* client address */
} ;
typedef struct DDPOpenSocketRec DDPOpenSocketRec, *DDPOpenSocketRecPtr, **DDPOpenSocketRecHndl;

struct DDPCloseSocketRec {
   Byte async; /* asyncronous flag */
   Byte command; /* DDP commnd to execute */
   Word result; /* error result from DDP operation */
   Byte socketNumber; /* socket # to close */
} ;
typedef struct DDPCloseSocketRec DDPCloseSocketRec, *DDPCloseSocketRecPtr, **DDPCloseSocketRecHndl;

struct DDPSendDatagramRec {
   Byte async; /* asyncronous flag */
   Byte command; /* DDP command to execute */
   Word result; /* error result from DDP operation */
   Byte checksum; /* calculated checksum */
   Word destNet; /* destination network # */
   Byte destNode; /* destination node # */
   Byte destSocket; /* destination socket # */
   Byte sourceSocket; /* DDP socket to send from */
   Byte ddpType; /* DDP protocol type */
   LongWord bdsPtr; /* pointer to the DDP BDS buffer */
} ;
typedef struct DDPSendDatagramRec DDPSendDatagramRec, *DDPSendDatagramRecPtr, **DDPSendDatagramRecHndl;

struct LAPWriteRec {
   Byte async; /* asyncronous flag */
   Byte command; /* lap command to execute */
   Word result; /* lap error result code */
   Byte destNode; /* destination node to send packet to */
   Byte lapType; /* lap protocol type to send */
   LongWord lapBDSPtr; /* pointer to the lap BDS buffer */
} ;
typedef struct LAPWriteRec LAPWriteRec, *LAPWriteRecPtr, **LAPWriteRecHndl;

struct LAPReadBufferRec {
   Byte async; /* asyncronous flag */
   Byte command; /* LAP command to execute */
   Word result; /* error result of the LAP operation */
   Word requestCount; /* how many BYTEs to transfer */
   LongWord bufferPtr; /* pointer to a buffer to store info */
   Byte purge; /* flag for purging the buffer if wrong size */
   Word amountTransfered; /* actual amount transfered */
} ;
typedef struct LAPReadBufferRec LAPReadBufferRec, *LAPReadBufferRecPtr, **LAPReadBufferRecHndl;

struct LAPAttachProtRec {
   Byte async; /* asyncronous flag */
   Byte command; /* LAP command to execute */
   Word result; /* error result of LAP operation */
   Byte protType; /* protocol type specifing the LAP type */
   LongWord protAddr; /* protocol address specifing the LAP handler */
} ;
typedef struct LAPAttachProtRec LAPAttachProtRec, *LAPAttachProtRecPtr, **LAPAttachProtRecHndl;

struct LAPRemoveProtRec {
   Byte async; /* asyncronous flag */
   Byte command; /* LAP command to execute */
   Word result; /* error result of LAP operation */
   Byte protType; /* protocol type specifing the LAP type */
} ;
typedef struct LAPRemoveProtRec LAPRemoveProtRec, *LAPRemoveProtRecPtr, **LAPRemoveProtRecHndl;

struct BDS {
   Word BufferLength;
   LongWord BufferPtr;
} ;
typedef struct BDS BDS, *BDSPtr, **BDSHndl;

struct NBPRNEntityNameRec {
   Byte reserved[9]; /*   */
   EntName entityName; /*   */
} ;
typedef struct NBPRNEntityNameRec NBPRNEntityNameRec, *NBPRNEntityNameRecPtr, **NBPRNEntityNameRecHndl;

struct NBPLUNameBufferRec {
   Word netNum; /*   */
   Byte nodeNum; /*   */
   Byte socketNum; /*   */
   Byte enumerator; /*   */
   EntName entityName; /*   */
} ;
typedef struct NBPLUNameBufferRec NBPLUNameBufferRec, *NBPLUNameBufferRecPtr, **NBPLUNameBufferRecHndl;

struct NBPRegisterNameRec {
   Byte async; /* asyncronous flag */
   Byte command; /* NBP command to execute */
   Word result; /* error result from NBP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   LongWord namePtr; /* pointer to the entityType */
   Byte rInterval; /* timeOut period before retrying */
   Byte rCount; /* number of retries to attempt */
   Word reserved; /* reserved for future use */
   Byte socketNumber; /* socket listner being registered */
   Byte checkFlag; /* flag for checking duplicate names */
} ;
typedef struct NBPRegisterNameRec NBPRegisterNameRec, *NBPRegisterNameRecPtr, **NBPRegisterNameRecHndl;

struct NBPRemoveNameRec {
   Byte async; /* asyncronous flag */
   Byte command; /* NBP command to execute */
   Word result; /* error result from NBP operation */
   LongWord entityPtr; /* pointer to the entity entityType */
} ;
typedef struct NBPRemoveNameRec NBPRemoveNameRec, *NBPRemoveNameRecPtr, **NBPRemoveNameRecHndl;

struct NBPLookupNameRec {
   Byte async; /* asyncronous flag */
   Byte command; /* NBP command to execute */
   Word result; /* error result from NBP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   LongWord entityPtr; /* pointer to the entity entityType */
   Byte rInterval; /* timeout interval before retrying */
   Byte rCount; /* number of retries to attempt */
   Word reserved; /* reserved for future use */
   Word bufferLength; /* length of the user buffer */
   LongWord bufferPtr; /* pointer to the user buffer */
   Byte maxMatch; /* maxiumn number of name matches */
   Byte actualMatch; /* actual number of matches */
} ;
typedef struct NBPLookupNameRec NBPLookupNameRec, *NBPLookupNameRecPtr, **NBPLookupNameRecHndl;

struct NBPConfirmNameRec {
   Byte async; /* asyncronous flag */
   Byte command; /* NBP command to execute */
   Word result; /* error result from NBP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   LongWord entityPtr; /* pointer to the entity name */
   Byte rInterval; /* timeout interval before retrying */
   Byte rCount; /* number of retries to attempt */
   Word reserved; /* reserved for future use */
   Word networkID; /* network number for confirmation */
   Byte nodeID; /* node number for confirmation */
   Byte socketID; /* socket number for confirmation */
   Byte actualSocketID; /* actual socket number confirmed */
} ;
typedef struct NBPConfirmNameRec NBPConfirmNameRec, *NBPConfirmNameRecPtr, **NBPConfirmNameRecHndl;

struct NBPKillRec {
   Byte async;
   Byte command;
   Word result;
   Pointer paramBlockPtr;
} ;
typedef struct NBPKillRec NBPKillRec, *NBPKillRecPtr, **NBPKillRecHndl;

struct PAPStatusRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   LongWord printerNamePtr; /* pointer to the printer name */
   LongWord statusBufferPtr; /* pointer to the status buffer */
} ;
typedef struct PAPStatusRec PAPStatusRec, *PAPStatusRecPtr, **PAPStatusRecHndl;

struct PAPOpenRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Byte sessRefID; /* session reference number */
   LongWord printerNamePtr; /* printer name pointer */
   Byte flowQuantum; /* number of ATP packets to be sent */
   LongWord statusBufferPtr; /* pointer to the status buffer */
} ;
typedef struct PAPOpenRec PAPOpenRec, *PAPOpenRecPtr, **PAPOpenRecHndl;

struct PAPCloseRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Byte sessRefID; /* session referance number */
} ;
typedef struct PAPCloseRec PAPCloseRec, *PAPCloseRecPtr, **PAPCloseRecHndl;

struct PAPReadRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Byte sessRefID; /* session reference # */
   Word bufferLength; /* length of the user buffer */
   LongWord bufferPtr; /* pointer to the user buffer */
   Byte papEOF; /* end of file flag */
} ;
typedef struct PAPReadRec PAPReadRec, *PAPReadRecPtr, **PAPReadRecHndl;

struct PAPWriteRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Byte sessRefID; /* session reference # */
   Word dataLength; /* data length */
   LongWord bufferPtr; /* pointer to the buffer */
   Byte papEOF; /* end of file flag */
} ;
typedef struct PAPWriteRec PAPWriteRec, *PAPWriteRecPtr, **PAPWriteRecHndl;

struct PAPUnloadRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PAP command to execute */
   Word result; /* error result from a PAP operation */
   LongWord completionPtr; /* pointer to the completion routine */
} ;
typedef struct PAPUnloadRec PAPUnloadRec, *PAPUnloadRecPtr, **PAPUnloadRecHndl;

struct PFIAttentionHeaderRec {
   Byte sessionRefNum;
   Byte attenType;
   Word atten;
   char serverName[33];
   char zoneName[34];
} ;
typedef struct PFIAttentionHeaderRec PFIAttentionHeaderRec, *PFIAttentionHeaderRecPtr, **PFIAttentionHeaderRecHndl;

struct PFIHooksMountingRec {
   Byte sessionRefNum;
   Byte p8UnitNum;
   char volumeName[29];
   Word volumeID;
   char serverName[33];
   char zoneName[34];
} ;
typedef struct PFIHooksMountingRec PFIHooksMountingRec, *PFIHooksMountingRecPtr, **PFIHooksMountingRecHndl;

struct PFIUserPrefixRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Byte directionFlag; /* high bit set to point to by User Pointer is stored in PFI */
   Word userNamePtr; /* name pointed to my User Mane Pointer */
} ;
typedef struct PFIUserPrefixRec PFIUserPrefixRec, *PFIUserPrefixRecPtr, **PFIUserPrefixRecHndl;

struct PFILoginRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Word networkID; /* network number for confirmation */
   Byte nodeID; /* node number for confirmation */
   Byte socketID; /* socket number for confirmation */
   Word cmdBufferLength; /* length of the user command buffer */
   LongWord cmdBufferPtr; /* pointer to the user command buffer */
   Word replyBufferLen; /* length of the reply buffer */
   LongWord replyBufferPtr; /* pointer to the reply buffer */
   Byte sessRefID; /* session reference number */
   LongWord attnRtnAddr;
} ;
typedef struct PFILoginRec PFILoginRec, *PFILoginRecPtr, **PFILoginRecHndl;

struct PFILoginContRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Byte sessRefID; /* session reference number */
   Word cmdBufferLength; /* length of the user command buffer */
   LongWord cmdBufferPtr; /* pointer to the user command buffer */
   Word replyBufferLen; /* length of the reply buffer */
   LongWord replyBufferPtr; /* pointer to the reply buffer */
} ;
typedef struct PFILoginContRec PFILoginContRec, *PFILoginContRecPtr, **PFILoginContRecHndl;

struct PFILogoutRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Byte sessRefID; /* session reference number */
} ;
typedef struct PFILogoutRec PFILogoutRec, *PFILogoutRecPtr, **PFILogoutRecHndl;

struct PFIMountvolRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Byte sessRefID; /* session reference number */
   Byte mountflag; /* mount flag field specifies whether the vol is to be mounted */
   LongWord volNamePtr; /* pointer to the volume that will be pseudo-mounted */
   Word volID; /* volume ID returned by AFP */
   Byte slotDrive; /* the slot/drive in ProDOS format into which the volume was pseudo-mounted */
   LongWord passwordPtr; /* pointer to password for the pseudo-mounted volume */
} ;
typedef struct PFIMountvolRec PFIMountvolRec, *PFIMountvolRecPtr, **PFIMountvolRecHndl;

struct PFIListBufferRec {
   Byte sessionRefNum;
   Byte Slot;
   Byte volumeName[28];
   Word volumeID;
} ;
typedef struct PFIListBufferRec PFIListBufferRec, *PFIListBufferRecPtr, **PFIListBufferRecHndl;

struct PFIListSessionsRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Word bufferLength; /* length of the user buffer */
   LongWord bufferPtr; /* pointer to the user buffer */
   Byte entriesRtn; /* contains the number of entries returned from the list of current sessions being maintained through the PFI and any volumes mounted for those sessions */
} ;
typedef struct PFIListSessionsRec PFIListSessionsRec, *PFIListSessionsRecPtr, **PFIListSessionsRecHndl;

struct PFITimeZoneRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Byte timeFlag; /* depending on bit set of the time falg field indicates whether the time should be added to or subtracted from the time zone selected */
} ;
typedef struct PFITimeZoneRec PFITimeZoneRec, *PFITimeZoneRecPtr, **PFITimeZoneRecHndl;

struct PFIGetSrcpathRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   LongWord bufferPtr; /* pointer to the user buffer where the pathname will be placed */
} ;
typedef struct PFIGetSrcpathRec PFIGetSrcpathRec, *PFIGetSrcpathRecPtr, **PFIGetSrcpathRecHndl;

struct PFIAccessRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Byte directionalFlag; /* if bit 7 of the directional flag is set, the access is being set */
   LongWord accessRights; /* access rights in AFP format */
   LongWord pathnamePtr; /* pointer the path name containing that volume */
   LongWord creatorNamePtr; /* if bit 6 of the directional flag is set, the creator's name will be dealt with */
   LongWord groupNamePtr; /* if bit 5 of the directional flag is set, the group name will be dealt with */
} ;
typedef struct PFIAccessRec PFIAccessRec, *PFIAccessRecPtr, **PFIAccessRecHndl;

struct PFINamingRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Byte directionalFlag; /* if bit 7 of the directional flag is set, the naming convention is being set */
   Byte namingConvFlag; /* if bit 7 of the naming convention flag is set, the naming convention becomes AFP format */
} ;
typedef struct PFINamingRec PFINamingRec, *PFINamingRecPtr, **PFINamingRecHndl;

struct PFIConvertTimeRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Byte formatFlag; /* if the format flag is set to 0, then from date time is AFP format  if the format flag is set to 1, then from date time is ProDOS format */
   LongWord fromDateTime; /* this field contains the From DATE/Time data (values) to convert, not pointers */
   LongWord toDateTime; /* this field contains the TO DATE/Time data (values) to convert, not pointers */
} ;
typedef struct PFIConvertTimeRec PFIConvertTimeRec, *PFIConvertTimeRecPtr, **PFIConvertTimeRecHndl;

struct PFISetBufferRec {
   Byte async; /* asyncronous flag */
   Byte command; /* PFI command to execute */
   Word result; /* error result from PFI operation */
   Byte dirFlag; /* $00 or $80 */
   Word bufferLength; /* Buffer Length */
   LongWord bufferPtr; /* if the format flag is set to 0, then from date time is AFP format */
} ;
typedef struct PFISetBufferRec PFISetBufferRec, *PFISetBufferRecPtr, **PFISetBufferRecHndl;

struct PFIHooksRec {
   Byte async; /*   */
   Byte command; /*   */
   Word result; /*   */
   Byte hookFlag; /*   */
   LongWord mountVector; /*   */
   LongWord unmountVector; /*   */
   LongWord attentionVector; /*   */
} ;
typedef struct PFIHooksRec PFIHooksRec, *PFIHooksRecPtr, **PFIHooksRecHndl;

struct PFILogin2Rec {
   Byte async;
   Byte command; /*   */
   Word result; /*   */
   Word networkID; /*   */
   Byte nodeID; /*   */
   Byte socketID; /*   */
   Word cmdBufferLength; /*   */
   LongWord cmdBufferPtr; /*   */
   Word replyBufferLen; /*   */
   LongWord replyBufferPtr; /*   */
   Byte sessRefID; /*   */
   LongWord attnRtnAddr; /*   */
   Pointer serverName; /*   */
   Pointer zoneName; /*   */
   Word afpVersionNum; /*   */
} ;
typedef struct PFILogin2Rec PFILogin2Rec, *PFILogin2RecPtr, **PFILogin2RecHndl;

struct PFIListSessions2Rec {
   Byte async; /*   */
   Byte command; /*   */
   Word result; /*   */
   Word bufferLength; /*   */
   LongWord bufferPtr; /*   */
   Byte entriesRtn; /*   */
} ;
typedef struct PFIListSessions2Rec PFIListSessions2Rec, *PFIListSessions2RecPtr, **PFIListSessions2RecHndl;

struct PFIGetSVersionRec {
   Byte async; /*   */
   Byte command; /*   */
   Word result; /*   */
   Byte sessRefID; /*   */
   Word afpVersionNum; /*   */
} ;
typedef struct PFIGetSVersionRec PFIGetSVersionRec, *PFIGetSVersionRecPtr, **PFIGetSVersionRecHndl;

struct ListSessionsBuffer {
   Byte refNum;
   Byte slotDrive;
   char volName[28];
   Word volID;
} ;
typedef struct ListSessionsBuffer ListSessionsBuffer, *ListSessionsBufferPtr, **ListSessionsBufferHndl;

struct RPMSetPrinterRec {
   Byte async; /* asyncronous flag */
   Byte command; /* RPM command to execute */
   Word result; /* error code returned from RPM operation */
   LongWord entityPtr; /* pointer to the entity name */
   Byte rpmFlags; /* RPM operation flags */
   Word flushInterval; /* flush interval */
   Word timeOut; /* timeOut */
   Word numberBuffers; /* number of buffers allocated */
} ;
typedef struct RPMSetPrinterRec RPMSetPrinterRec, *RPMSetPrinterRecPtr, **RPMSetPrinterRecHndl;

struct RPMCloseSessionRec {
   Byte async;
   Byte command;
   Word result;
} ;
typedef struct RPMCloseSessionRec RPMCloseSessionRec, *RPMCloseSessionRecPtr, **RPMCloseSessionRecHndl;

struct RPMFlushSessionRec {
   Byte async;
   Byte command;
   Byte result;
} ;
typedef struct RPMFlushSessionRec RPMFlushSessionRec, *RPMFlushSessionRecPtr, **RPMFlushSessionRecHndl;

struct ZIPGetMyZoneRec {
   Byte async; /* asyncronous flag */
   Byte command; /* ZIP Command to execute */
   Word result; /* error result from a ZIP operation */
   LongWord completionPtr; /* Pointer to the completion routine */
   LongWord bufferPtr; /* pointe to the buffer */
   Byte timeOut; /* timeout interval for retrying */
   Byte retry; /* number of retries to attempt */
   Word reserved; /* reserved for future use */
} ;
typedef struct ZIPGetMyZoneRec ZIPGetMyZoneRec, *ZIPGetMyZoneRecPtr, **ZIPGetMyZoneRecHndl;

struct ZIPGetZoneListRec {
   Byte async; /* asyncronous flag */
   Byte command; /* ZIP command to execute */
   Word result; /* error result from a ZIP operation */
   LongWord completionPtr; /* pointer to the completion routine */
   Word bufferLength; /* length of the user buffer */
   LongWord bufferPtr; /* pointer to the user buffer */
   Byte bridgeNodeID; /* bridge node number */
   Word startIndex; /* starting index of the buffer */
   Byte timeOut; /* timeout interval for retrying */
   Byte retry; /* number of retries to attempt */
   Word zonesFound; /* number of zones found */
   Word reserved; /* reserved for future use (not clear in manual) */
} ;
typedef struct ZIPGetZoneListRec ZIPGetZoneListRec, *ZIPGetZoneListRecPtr, **ZIPGetZoneListRecHndl;

struct CmdBlock {
   Word cmdLength; /* AFP Command Length */
   Pointer cmdBlkAddr; /* Address of AFP Command */
   Word replyLength; /* Size of Reply Buffer */
   Pointer replyBuffer; /* Address of Reply Buffer */
   Word writeLength; /* Size of Data to be written */
   Pointer writeBuffer; /* Address of Write Buffer */
} ;
typedef struct CmdBlock CmdBlock, *CmdBlockPtr, **CmdBlockHndl;


/*
    Causes packet and timer interrupts to be buffered without
    being dispatched.  Use with completion routines, socket
    listeners, and in place of disabling interrupts.
*/
extern pascal void RamForbid() inline(0,0xE11018);


/*
    Reenables packet and timer interrupts. 
    Call after RamForbid.
*/
extern pascal void RamPermit() inline(0,0xE1101C);


/*
    AppleTalk calls return result value of type OSErr.
    This value is valid only for calls that are made syncronously.
*/

extern OSErr _CALLAT();

OSErr ASPCloseSession(pBlockPtr) ASPCloseSessionRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ASPCommand(pBlockPtr) ASPCommandRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ASPGetParms(pBlockPtr) ASPGetParmsRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ASPGetStatus(pBlockPtr) ASPGetStatusRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ASPOpenSession(pBlockPtr) ASPOpenSessionRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ASPWrite(pBlockPtr) ASPWriteRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATBoot(pBlockPtr) ATBootRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATCancelTimer(pBlockPtr) ATCancelTimerRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATGetGlobal(pBlockPtr) ATGetGlobalRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATGetInfo(pBlockPtr) ATGetInfoRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATInstallTimer(pBlockPtr) ATInstallTimerRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATPCancelReq(pBlockPtr) ATPCancelReqRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATPCloseSocket(pBlockPtr) ATPCloseSocketRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATPGetReq(pBlockPtr) ATPGetReqRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATPOpenSocket(pBlockPtr) ATPOpenSocketRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATPRelCB(pBlockPtr) ATPRelCBRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATPSendReq(pBlockPtr) ATPSendReqRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATPSendResp(pBlockPtr) ATPSendRespRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ATRemoveTimer(pBlockPtr) ATInstallTimerRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr DDPCloseSocket(pBlockPtr) DDPCloseSocketRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr DDPOpenSocket(pBlockPtr) DDPOpenSocketRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr DDPSendDatagram(pBlockPtr) DDPSendDatagramRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr LAPAttachProt(pBlockPtr) LAPAttachProtRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr LAPReadBuffer(pBlockPtr) LAPReadBufferRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr LAPRemoveProt(pBlockPtr) LAPRemoveProtRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr LAPWrite(pBlockPtr) LAPWriteRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr NBPConfirmName(pBlockPtr) NBPConfirmNameRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr NBPKill(pBlockPtr) NBPKillRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr NBPLookupName(pBlockPtr) NBPLookupNameRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr NBPRegisterName(pBlockPtr) NBPRegisterNameRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr NBPRemoveName(pBlockPtr) NBPRemoveNameRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PAPClose(pBlockPtr) PAPCloseRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PAPOpen(pBlockPtr) PAPOpenRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PAPRead(pBlockPtr) PAPReadRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PAPStatus(pBlockPtr) PAPStatusRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PAPUnload(pBlockPtr) PAPUnloadRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PAPWrite(pBlockPtr) PAPWriteRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFIAccess(pBlockPtr) PFIAccessRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFIConvertTime(pBlockPtr) PFIConvertTimeRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFIGetSrcPath(pBlockPtr) PFIGetSrcpathRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFIGetSVersion(pBlockPtr) PFIGetSVersionRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFIHooks(pBlockPtr) PFIHooksRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFIListSessions(pBlockPtr) PFIListSessionsRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFIListSessions2(pBlockPtr) PFIListSessions2Rec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFILogin(pBlockPtr) PFILoginRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFILogin2(pBlockPtr) PFILogin2Rec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFILoginCont(pBlockPtr) PFILoginContRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFILogOut(pBlockPtr) PFILogoutRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFIMountVol(pBlockPtr) PFIMountvolRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFINaming(pBlockPtr) PFINamingRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFISetBuffer(pBlockPtr) PFISetBufferRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFITimeZone(pBlockPtr) PFITimeZoneRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr PFIUserPrefix(pBlockPtr) PFIUserPrefixRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr RPMCloseSession(pBlockPtr) RPMCloseSessionRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr RPMFlushSession(pBlockPtr) RPMFlushSessionRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr RPMSetPrinter(pBlockPtr) RPMSetPrinterRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ZIPGetMyZone(pBlockPtr) ZIPGetMyZoneRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }
OSErr ZIPGetZoneList(pBlockPtr) ZIPGetZoneListRec* pBlockPtr; { return(_CALLAT(pBlockPtr)); }

#endif
